
; Vacuum Pump Controller


	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F1459
	#include p16f1459.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF &_IESO_OFF & _FCMEN_OFF

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _WRT_OFF & _CPUDIV_NOCLKDIV & _USBLSCLK_24MHz & _PLLMULT_4x & _PLLEN_DISABLED & _STVREN_ON & _BORV_HI & _LPBOR_OFF & _LVP_OFF 

;..................................................................................................................................
; define;
; Bank 0 RAM 

GATE_STAT		equ	H'20'		; blast gate status	
STOREI1			equ	H'21'		; delay counter within interrupt
STOREI2			equ	H'22'		; delay counter within interrupt
VACUUM_RUN		equ	H'23'		; vacuum run time after appliance off
GATE_OP			equ	H'24'		; Blast Gate Operate period
VACUUM_DN		equ	H'25'		; Vacuum wind down time
VACUUM_TMR		equ	H'26'		; vacuum run time timer
GATE_TMR		equ	H'27'		; blast gate operate timer
WND_DN_TMR		equ	H'28'		; vacuum wind down timer
APPLIANCE		equ	H'29'		; appliance current flow measurement value
SWITCHES		equ	H'2A'		; switches flag. Bit 1 set when S1 pressed, Bit 2 when switch S2 pressed
SWITCH1			equ	H'2B'		; switch 1 flag
MANUAL_SET		equ	H'2C'		; manual counter for Vacuum LED momentary flash off and pump on

; All Banks RAM
READADDMS 		equ	H'70'		; ms Byte of Program Address to read from Flash
READADDLS		equ	H'71'		; ls byte of program address to read from Flash
TEMP_VAL		equ	H'72'		; temporary value for ms byte in read and A/D conversion ms byte store 
LOOP			equ	H'73'		; flash write memory bytes
STORE1			equ	H'74'		; delay counter	1
STORE2			equ	H'75'		; delay counter 2
TEMP			equ	H'76'		; temporary
INTCON_STORE	equ	H'77'		; interrupt state

	org	H'1F80'		; initial address from which data is stored (High Endurance Flash location for the ls byte)

	DA	H'3F00'     ; blast gate status. 0 = off, 1 = on

;.................................................................

	org		0
	goto	MAIN
	org     4				; interrupt vector @ 4

INTERRUPT

; check interrupt source
	movlb	D'0'			; bank 0
	btfss	PIR1,TMR1IF		; timer1 interrupt flag 
	goto	IOC_FLGS
	bcf		PIR1,TMR1IF		; clear flag
; pre-load timer 1 with 6943 decimal (H181F)for 468.75ms rate. (x64 gives ~ 468ms to 30s maximum)
	bcf		T1CON,0
	movlw	H'18'
	movwf	TMR1H			; ms byte timer 1
	movlw	H'1F'			; 
	movfw	TMR1L			; ls byte timer 1
	bsf		T1CON,0

; Check and decrease timers to 0

; Vacuum run
	movf	VACUUM_TMR,w	; vacuum run time
	btfss	STATUS,Z		; if zero do not decrease
	decf	VACUUM_TMR,f

; Blast Gate opening and closing (operate) period
	movf	GATE_TMR,w		; blast gate operate time
	btfsc	STATUS,Z		; if zero do not decrease
	goto	VAC		
	decfsz	GATE_TMR,f
	goto	FG
	movlb	D'2'		; bank 2
	bsf		LATB,4		; Blast Gate LED off
	movlb	D'0'		; bank 0
	goto	VAC
FG
; flash GATE LED
; if GATE_TMR,0 is set, LED off
	btfss	GATE_TMR,0
	goto	GTE_OFF
	movlb	D'2'		; bank 2
	bsf		LATB,4		; Blast Gate LED off
	movlb	D'0'		; bank 0
	goto	VAC
; if GATE_TMR,0 is clear, LED on
GTE_OFF
	movlb	D'2'		; bank 2
	bcf		LATB,4		; Blast Gate LED on
	movlb	D'0'		; bank 0

VAC
; if SWITCH1,0 is set then momentarily flash Vacuum LED off
	btfss	SWITCH1,0
	goto	WIND1		; not set
	incf	MANUAL_SET,f; manual setting for Vacuum LED flash off and pump on
	movf	MANUAL_SET,w
	sublw	D'2'
	btfsc	STATUS,C
	goto 	VAC_ON1
; flash off	 
	movlb	D'2'		; bank 2
	bsf		LATC,0		; Vacuum LED off
	movlb	D'0'		; bank 0
	clrf	MANUAL_SET
	call	DELAY_INT	; 100ms	
VAC_ON1
	movlb	D'2'		; bank 2
	bcf		LATC,0		; Vacuum LED on
	movlb	D'0'		; bank 0


; Vacuum wind down period
WIND1
	movf	WND_DN_TMR,w	; vacuum wind down period (inertia from power off)
	btfsc	STATUS,Z		; if zero do not decrease
	retfie			
	decfsz	WND_DN_TMR,f
	goto	FLS_VAC
	movlb	D'2'		; bank 2
	bsf		LATC,0		; Vacuum LED off
	bsf		LATB,4		; Gate LED off
	movlb	D'0'		; bank 0
	retfie

FLS_VAC ; flash vacuum LED
; if WND_DN_TMR,0 is set, LED off

	btfss	WND_DN_TMR,0
	goto	VAC_OFF
	movlb	D'2'		; bank 2
	bsf		LATC,0		; Vacuum LED off
	movlb	D'0'		; bank 0
	retfie

; if WND_DN_TMR,0 is clear, LED on
VAC_OFF
	movlb	D'2'		; bank 2
	bcf		LATC,0		; Vacuum LED on
	movlb	D'0'		; bank 0
	retfie

IOC_FLGS ; interrupt on change via S1 and S2
	movlb	D'7'			; bank 7
	btfsc	IOCAF,4			; S2
	goto	SWITCH2
	btfsc	IOCAF,5			; S1
	goto	SWITCHE1
	btfsc	IOCBF,6			; interlink detect
	goto	INTER_LNK
	retfie

SWITCHE1; switch on or off vacuum pump
	bcf		IOCAF,5
	movlb	D'0'		; bank 0
	call	DELAY_INT	; 100ms	
; if RA5 still low, continue, otherwise delay and clear interrupt flag
	btfsc	PORTA,5
	goto	CLR5

	btfss	PORTC,4		; if set then vacuum pump is on
	goto	VAC_ON
; clear vacuum relay and LED
	movlb	D'2'		; bank 2
	bsf		LATC,0		; vacuum LED off
	bcf		LATC,4		; relay 1 off
	bcf		LATB,5		; interlink off
	movlb	D'0'		; bank 0
	clrf	SWITCH1		; S1 flag
	goto	CLR4
VAC_ON

; if blast gate is on and SWITCH1,1 is set then blast gate is kept on (see under 'Patch1' in main code)
; so set SWITCH1,1 if blast gate is on
	btfsc	PORTB,7
	bsf		SWITCH1,1
	bsf		SWITCH1,0 	; for manual mode flashing vacuum LED 
; vacuum relay on
	movlb	D'2'		; bank 2
	bcf		LATC,0		; Vacuum LED on
	bsf		LATC,4		; relay 1 on
	bsf		LATB,5		; interlink on
	movlb	D'0'		; bank 0
CLR5
	call	DELAY_INT	; 100ms	
; clear timers
	clrf	VACUUM_TMR	; vacuum run time timer
	clrf	GATE_TMR	; blast gate operate timer
	clrf	WND_DN_TMR	; vacuum wind down timer
	bsf		SWITCHES,1	; switch S1 flag set 
	movlb	D'7'		; bank 7
	bcf		IOCAF,5
	retfie

SWITCH2 ; blast gate on or off
	bcf		IOCAF,4
	movlb	D'0'			; bank 0

	call	DELAY_INT	; 100ms	
; if RA4 still low, continue, otherwise delay and clear interrupt flag
	btfsc	PORTA,4
	goto	CLR4

	btfss	PORTB,7			; if set then blast gate is on
	goto	BR_ON
; clear blast gate relay and LED
	movlb	D'2'		; bank 2
	bsf		LATB,4		; Gate LED off
	bcf		LATB,7		; relay 2 off
	movlb	D'0'		; bank 0
	goto	CLR4
BR_ON
; blast relay on
	movlb	D'2'		; bank 2
	bcf		LATB,4		; Gate LED on
	bsf		LATB,7		; relay 2 on
	movlb	D'0'		; bank 0
CLR4
	call	DELAY_INT	; 100ms	
; clear timers
	clrf	VACUUM_TMR	; vacuum run time timer
	clrf	GATE_TMR	; blast gate operate timer
	clrf	WND_DN_TMR	; vacuum wind down timer
	bsf		SWITCHES,2	; switch S2 flag set
	movlb	D'7'		; bank 7
	bcf		IOCAF,4
	retfie

INTER_LNK
	bcf		IOCBF,6
	movlb	D'0'		; bank 0

	retfie

;------------------------------------------------------------------------------------------------------

MAIN

; set inputs/outputs
	movlb	D'2'		; bank 2
	clrf	LATA
	clrf	LATB
	clrf	LATC
	bsf		LATC,0		; Vacuum LED off
	bsf		LATB,4		; Blast Gate LED off 
USB
	movlb	D'29'
	bcf		UCON,3		; USB off
	bcf		UCON,1
; weak pullups off/on
	movlb	D'4'		; bank4	WPUA/B
	movlw	B'00111000' ; RA3, RA4, RA5 pullups
	movwf	WPUA
; set I/O
	movlb	D'1'		; bank1	TRISA/B/C
	movlw   B'00111011'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'01000000'	; I/O 
	movwf	TRISB		; port B data direction register
	movlw	B'11001110'
	movwf	TRISC		; port C data direction 
; options
	movlw	B'00000111'	; weak pullups set via WPUA/B TMR0/256
	movwf	OPTION_REG	; 
; oscillator	
	movlw	B'00110110'	; for 4MHz;
	movwf	OSCCON		; osc
; analog inputs
	movlb	D'3'		; bank3	
	clrf	ANSELA
	clrf	ANSELB
	movlw	B'11001100'	; 
	movwf	ANSELC
; edge interrupts for S1 and S2
	movlb	D'7'		; bank 7
	bsf		IOCAN,4		; falling edge when S2 pressed
	bsf		IOCAN,5		; falling edge when S1 pressed
;	bsf		IOCBN,6		; interlink
	movlb	D'0'		; bank 0
; timer1
	movlw	B'00110001'	; timer1 /8  prescaler (8us per count) from 4MHz oscillator
	movwf	T1CON

;******************************************************************

; short start up delay
	call	DELAYxms	; 300ms
; initial values
INIT; initialise
; timers
	clrf	VACUUM_TMR	; vacuum run time
	clrf	GATE_TMR	; blast gate operate time
	clrf	WND_DN_TMR	; vacuum wind down period
	clrf	SWITCH1		; switch S1 flag
	clrf	SWITCHES	; S1,S2 flags
	clrf	MANUAL_SET	; manual counter for Vacuum LED momentary flash off and pump on

; read flash stored value for blast gate status
	movlw	H'1F'		; ms address byte 
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data for ls byte (8-bits)
	movwf	GATE_STAT	; blast gate status	

; setup interrupts
SET_I
	movlb	D'0'		; bank 0
	bsf		INTCON,PEIE	; enable peripheral interrupts
	bsf		INTCON,IOCIE; enable interrupt on change

	movlb	D'1'		; bank 1
	bsf		PIE1,TMR1IE	; enable timer1 interrupt
	movlb	D'0'		; bank 0
	bcf		PIR1,TMR1IF	; timer1 interrupt flag
	bsf		INTCON,GIE	; global interrupts enable 

; when blast gate shouldbe on, then operate gate and set timer
	btfss	GATE_STAT,0	; blast gate status
	goto	LOOPING		; bypass driving blast gate
	movlb	D'2'		; bank 2
	bsf		LATB,7		; relay2 on
	bcf		LATB,4		; Blast Gate LED on
	movlb	D'0'		; bank 0
; start timer
	call	BG_VALUE	; Blast Gate timer value (get VR2 setting)
	movf	GATE_OP,w	; timer value
	movwf	GATE_TMR	; timer running

; when GATE_TMR = 0 set Gate LED on
GTE_TMR_END
	movf	GATE_TMR,w
	btfss	STATUS,Z
	goto	GTE_TMR_END

	movlb	D'2'		; bank 2
	bcf		LATB,4		; Blast Gate LED on
	movlb	D'0'		; bank 0


LOOPING ; program returns to here

	clrf	SWITCHES	; switch flag cleared

	clrf	VACUUM_TMR	; vacuum run time
	clrf	GATE_TMR	; blast gate operate time
	clrf	WND_DN_TMR	; vacuum wind down period
	
	call	APP_VALUE	; read A/D value of appliance current for on/off
; value is in APPLIANCE
	movf	APPLIANCE,w
	sublw	D'30'		; ~600mV (around 60W load)
	btfsc	STATUS,C	; if negative then Appliance current reading is >30	
	goto	CHK_INTER	; check interlinking

BLAST_OPEN
; make sure blast gate is open (RB7 is high)
	btfsc	PORTB,7
	goto	WT1
	movlb	D'2'		; bank 2
	bsf		LATB,7		; relay2 on for blast gate
	bcf		LATB,4		; Blast Gate LED on
	movlb	D'0'		; bank 0

; store blast gate status
; read flash stored value for blast gate status
	movlw	H'1F'		; ms address byte 
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data for ls byte (8-bits)
	bsf		GATE_STAT,0	; blast gate status 'on'
;If w and GATE_STAT are different then store new value
	xorwf	GATE_STAT,w
	btfss	STATUS,Z
	call	STORE		; store in flash

; start timer
	call	BG_VALUE	; Blast Gate timer value (get VR2 setting)
	movf	GATE_OP,w	; timer value

; if GATE_OP = 1 then bypass
	xorlw	D'1'
	btfsc	STATUS,Z	; if a 1 prevent from loading timer
	goto	WT1
	movf	GATE_OP,w
	movwf	GATE_TMR	; timer running
; Start Vacuum pump when GATE_TMR is 0
WT1

; check S1 and S2
	movf	SWITCHES,w	; if not clear bypass operation
	btfss	STATUS,Z
	goto	LOOPING

	movf	GATE_TMR,w
	btfss	STATUS,Z
	goto	WT1

	movlb	D'2'		; bank 2
	bsf		LATC,4		; relay1 on for vacuum pump
	bcf		LATC,0		; Vacuum LED on
	bcf		LATB,4		; Blast gate LED on	
	bsf		LATB,5		; interlink driven low via base drive to Q3
	movlb	D'0'		; bank 0

; check when appliance is off
RUN_UNTIL_OFF
	call	APP_VALUE	; read A/D value of appliance current for on/off
; value is in APPLIANCE
	movf	APPLIANCE,w
	sublw	D'5'		; ~100mV (around 10W load)
	btfss	STATUS,C	; if 0 or negative (C=0) then Appliance current reading is >10	
	goto	RUN_UNTIL_OFF

RUN_VAC_X
; run vacuum after appliance is off
	call	VAC_VALUE
	movf	VACUUM_RUN,w; timer value
; if a 1 then bypass timer
	xorlw	D'1'
	btfsc	STATUS,Z
	goto	STP_VAC
	movf	VACUUM_RUN,w
	movwf	VACUUM_TMR	; timer
; stop vacuum pump after timer is cleared to 0
STP_VAC
; check S1 and S2
	movf	SWITCHES,w	; if not clear bypass operation
	btfss	STATUS,Z
	goto	LOOPING

	movf	VACUUM_TMR,w
	btfss	STATUS,Z
	goto	STP_VAC
; switch off Vacuum
	movlb	D'2'		; bank 2
	bcf		LATC,4		; relay1 off for vacuum pump
	bsf		LATC,0		; Vacuum LED off
	bcf		LATB,5		; interlink off
	movlb	D'0'		; bank 0
	
; close Blast gate after vacuum wind down time if JP1 closed (RC1 low)
	btfsc	PORTC,1		; is JP1 open (5V) or closed (0V)
	goto	LOOPING

	call	WD_VALUE
	movf	VACUUM_DN,w	; timer value
	movwf	WND_DN_TMR	; timer
; close blast gate after timer is cleared to 0
CHK_WND_DN
; check S1 and S2
	movf	SWITCHES,w	; if not clear bypass operation
	btfss	STATUS,Z
	goto	LOOPING

	movf	WND_DN_TMR,w
	btfss	STATUS,Z
	goto	CHK_WND_DN
; close gate
	movlb	D'2'		; bank 2
	bcf		LATB,7		; relay2 off for blast gate
	bsf		LATB,4		; blast gate LED off
	movlb	D'0'		; bank 0
; store new blast gate status
; read flash stored value for blast gate status
	movlw	H'1F'		; ms address byte 
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data for ls byte (8-bits)
;If w and GATE_STAT are different then store new value
	bcf		GATE_STAT,0	; blast gate status 'off'
	xorwf	GATE_STAT,w
	btfss	STATUS,Z
	call	STORE		; store in flash
	goto	LOOPING


CHK_INTER ; check interlink

	btfsc	PORTB,6		; if low then interlink
	goto	LOOPING
	call	DELAYms
	btfsc	PORTB,6		; make sure wasn't a glitch
	goto	LOOPING

; if blast gate off bypass closing period
	btfss	PORTB,7
	goto	WT2
	
; Set Blast Gate off if on. Blast gate LED flashes during closing period 
; Blast LED off
; make sure blast gate is shut 

; if blast gate on and SWITCHES,1 is set bypass switching off
; SWITCH1,1 cleared when off
Patch1
	btfsc	SWITCH1,1
	goto	WT2

	movlb	D'2'		; bank 2
	bcf		LATB,7		; relay2 off for blast gate
	bsf		LATB,4		; Blast Gate LED off
	movlb	D'0'		; bank 0

; read flash stored value for blast gate status
	movlw	H'1F'		; ms address byte 
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data for ls byte (8-bits)
; If w and GATE_STAT are different then store new value
	bcf		GATE_STAT,0	; blast gate status 'off'
	xorwf	GATE_STAT,w
	btfss	STATUS,Z
	call	STORE		; store in flash

; start timer
	call	BG_VALUE	; Blast Gate timer value (get VR2 setting)
	movf	GATE_OP,w	; timer value
	movwf	GATE_TMR	; timer running	

WT2
; check S1 and S2
	movf	SWITCHES,w	; if not clear bypass operation
	btfss	STATUS,Z
	goto	LOOPING

	movf	GATE_TMR,w
	btfss	STATUS,Z
	goto	WT2

; Vacuum Pump and LED is on (required if it is the master)

	movlb	D'2'		; bank 2
	bsf		LATC,4		; relay1 on for vacuum pump
	bcf		LATC,0		; vacuum pump LED on
	movlb	D'0'		; bank 0

; After interlink is off
INTER_OFF
	btfss	PORTB,6
	goto	INTER_OFF
; Vacuum pump is off and vacuum LED flashes during pump wind down; 
	movlb	D'2'		; bank 2
	bcf		LATC,4		; relay1 off for vacuum pump
	bsf		LATC,0		; vacuum pump LED off
	movlb	D'0'		; bank 0
	goto	LOOPING

; below is optional wind down
;	call	WD_VALUE
;	movf	VACUUM_DN,w	; timer value
;	movwf	WND_DN_TMR	; timer

CHK_WND_DN2
; check S1 and S2
;	movf	SWITCHES,w	; if not clear bypass operation
;	btfss	STATUS,Z
;	goto	LOOPING

;	movf	WND_DN_TMR,w
;	btfss	STATUS,Z
;	goto	CHK_WND_DN2
	goto	LOOPING

;/////////////////////////////////////////////////////////////

; subroutines
APP_VALUE
; A/D conversion
; Channel 6 A/D value for appliance
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00011000'	; channel 6  
; channel 6	; current transformer and rectifier
	movwf	ADCON0
	call	GET_AD		; acquire digital value
	movwf	APPLIANCE	; A/D value of appliance current
	return

;.....................................................

VAC_VALUE
; A/D conversion
; Channel 7 A/D value for VR1
; Vacuum run period after appliance is off

	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00011100'	; channel 7  
; 00011100	; channel 7	; VR1
	movwf	ADCON0
	call	GET_AD		; acquire digital value
	movwf	VACUUM_RUN	; store value. vacuum run time after appliance off
	lsrf	VACUUM_RUN,f
	lsrf	VACUUM_RUN,f; 0-63 value
	incf	VACUUM_RUN,f; prevent a zero for 1-64 (30s maximum)	
	return

;......................................

; Channel 8 A/D value for VR2
; Blast Gate operate period
BG_VALUE
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00100000'	; channel 8  
	movwf	ADCON0
	call	GET_AD		; acquire digital value
	movwf	GATE_OP		; Blast Gate Operate period
	lsrf	GATE_OP,f	; 0-127
	lsrf	GATE_OP,f	; 0-63 value
	lsrf	GATE_OP,f	; 0-31
	lsrf	GATE_OP,f	; 0-15 value
	incf	GATE_OP,f	; prevent a zero for 1-16 (7.5s maximum)	
	return

;.......................................

; Channel 9 Vacuum pump wind down period
WD_VALUE
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00100100'	; channel 9  
	movwf	ADCON0
	call	GET_AD		; acquire digital value
	movwf	VACUUM_DN	; Vacuum pump wind down period
	lsrf	VACUUM_DN,f
	lsrf	VACUUM_DN,f	; 0-63 value
	lsrf	VACUUM_DN,f
	lsrf	VACUUM_DN,f	; 0-15 value
	incf	VACUUM_DN,f	; prevent a zero for 1-16 (7.5s maximum)
	return

;............................................

; subroutine for acquiring A/D value
GET_AD
	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	bcf		INTCON,GIE

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT1
	decfsz	TEMP,f
	goto	WAIT1	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	bsf		INTCON,GIE
	movf	ADRESH,w
	movlb	D'0'			; bank 0
	return

;...............................................

; delay loop 

DELAYxms
	movlw	D'3'		; 300ms
XMS						; x milli seconds (x sets time)
	movwf	TEMP_VAL
DLYLOOP
	call	DELAYms
	decfsz	TEMP_VAL,f
	goto	DLYLOOP

DELAYms ; 100ms/ cycle
	movlw	D'186'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B2'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAY_INT ; for INTERRUPT use only!
; delay for during interrupt, 100ms
	movlw	D'186'		; delay value
DELAYI
	movwf	STOREI1		; STOREI1 is number of loops value
;	clrwdt				; was unchecked
LOOP1	
	movlw	H'B2'
	movwf	STOREI2		; STOREI2 is internal loop value	
LOOP2
	decfsz	STOREI2,f
	goto	LOOP2
	decfsz	STOREI1,f
	goto	LOOP1
	return

;.....................................................................

STORE ; store values from RAM to Flash

; Flash high endurance locations	
	movlw	H'1F'			; ms address byte 
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS		; ls address byte

; start of RAM
	movlw	H'20'
	movwf	FSR0H
	movlw 	H'00'
	movwf	FSR0L

; write to data memory
WRITE
	clrf	LOOP			; counter
	movf	INTCON,w
	movwf	INTCON_STORE	; store GIE (bit7)
	bcf		INTCON,GIE 		; Disable interrupts so required sequences will execute properly

; load write latches
	movlb	D'03'			; bank 3
	movf	READADDMS,W		; Load upper 6 bits of address boundary			
	movwf	PMADRH ;
	movf	READADDLS,W 	; Load lower 8 bits of erase address boundary
	andlw	B'11110000'		; clear ls bits to start of ID memory
	movwf	PMADRL ;

; erase first
	bcf		PMCON1,CFGS 	; Not configuration space
	bsf		PMCON1,FREE 	; Specify an erase operation
	bsf		PMCON1,WREN 	; Enable writes
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' ;
	movwf	PMCON2 			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin erase
	nop					 	; NOP instructions are forced as processor writes all the program memory write latches simultaneously to program memory.
	nop	 
	bcf		PMCON1,WREN 	; Disable writes

; load latches
	movf	READADDMS,W		; Load upper 6 bits of  address boundary			
	movwf	PMADRH ;
	movf	READADDLS,W 	; Load lower 8 bits of erase address boundary
	andlw	B'11110000'		; clear ls bits to start of ID memory
	movwf	PMADRL ;

	bcf		PMCON1,CFGS		; Not configuration space
	bsf		PMCON1,WREN	 	; Enable writes
	bsf		PMCON1,LWLO 	; Only Load Write Latches

LOOPW
	moviw	FSR0++ 			; Load first data byte into lower
	movwf	PMDATL ;
	movlw	H'3F'	 		; Load second data byte into upper always 3F
	movwf	PMDATH ;		; Load second data byte into upper

	movf	LOOP,w		 	; Check lower bits of address
	xorlw	0x04			; Check if we're on the last of addresses
	btfsc	STATUS,Z 		; Exit if last of words,
	goto	START_WRITE ;

	movlw	H'55'		 	; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' ;
	movwf	PMCON2			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin write
	nop					 	; nop instructions are forced as processor loads program memory write latches
	nop ;
	incf	PMADRL,f	 	; Still loading latches Increment address
	incf	LOOP,f
	goto	LOOPW

START_WRITE ; write
	bcf		PMCON1,LWLO		; No more loading latches - Start Flash program
; memory write
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' ;
	movwf	PMCON2 			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin write
	nop						; NOP instructions are forced as processor writes all the program memory write latches simultaneously to program memory.
	nop	  
	bcf		PMCON1,WREN 	; Disable writes
	movlb	D'0'			; bank 0
	btfsc	INTCON_STORE,7	; if set then set GIE
	bsf		INTCON,GIE		; re-enable interrupts 
	return

;.......................................................................................
; read data memory
READ; upon return 'w' has read data

	movlb	D'3'		;  bank 3 
	movf	READADDMS,w 
	movwf 	PMADRH		; ms Byte of Program Address to read
	movf	READADDLS,w
	movwf 	PMADRL 		; ls Byte of Program Address to read
	bcf		PMCON1,CFGS	; avoid configuration space
	bsf	 	PMCON1,RD 	; Read
	nop 					
	nop
; memory is read in second cycle PM read instruction
	movf	PMDATH,w 	; ms Byte of Program data 
	movwf	TEMP_VAL	; ms byte of data in TEMP_VAL
	movf	PMDATL,w 	; ls Byte of Program data in 'w'
	movlb	D'0'		; bank 0
	return

; 	

 end
